import { Tent, Mail, Phone, MapPin, Clock, Facebook, Instagram, MessageCircle } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-nature">
      <div className="container">
        <div className="footer-content-nature">
          <div className="footer-section-nature">
            <div className="footer-logo-nature">
              <div className="footer-logo-icon-wrapper-nature">
                <Tent className="footer-logo-icon-nature" size={28} />
              </div>
              <h2 className="footer-logo-text-nature">CAMPGEAR</h2>
            </div>
            <p className="footer-description-nature">
              Профессиональное оборудование для кемпинга и походов. 
              Качественное снаряжение для ваших приключений на природе.
            </p>
            <div className="footer-social-nature">
              <a href="#" className="social-link-nature">
                <Instagram size={20} />
              </a>
              <a href="#" className="social-link-nature">
                <Facebook size={20} />
              </a>
              <a href="#" className="social-link-nature">
                <MessageCircle size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-nature">
            <h3 className="footer-title-nature">Навигация</h3>
            <ul className="footer-links-nature">
              <li><a href="/">Мои аренды</a></li>
              <li><a href="/rent">Арендовать</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-nature">
            <h3 className="footer-title-nature">Контакты</h3>
            <ul className="footer-links-nature">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@campgear.ru">info@campgear.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Походная, 12</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-nature">
          <p>&copy; 2025 CAMPGEAR. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

